import java.lang.*;
import java.util.*;
import java.io.*;
import javax.imageio.*;
import javax.imageio.stream.*; 
import javax.imageio.plugins.jpeg.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.awt.Toolkit.*;
import java.awt.datatransfer.*;

class abstract_fractalc {
  int mode;
  int max_iter_pow2;
  static int MANDELBROT_MODE = 0;
  static int JUILA_MODE = 1;

  double view_x_m;
  double view_w_m;
  double view_y_m;
  double view_h_m;


  double view_x;
  double view_w;
  double view_y;
  double view_h;

  //int max_iter_pow2;
  int fractal_type;

  abstract_fractalc() {
    max_iter_pow2 = 6;
    view_x_m = -2.0;
    view_w_m = 2.666;
    view_y_m = -1.0;
    view_h_m = 2.0;
    reset_view();
    mode = MANDELBROT_MODE;
    
  }

  int get_fractal_type() {
    return fractal_type;
  }

  boolean is_juila_mode_on() {
    if (mode == JUILA_MODE) {return true;}
    return false;
  }
  boolean is_mandelbrot_mode_on() {
    if (mode == MANDELBROT_MODE) {return true;}
    return false;
  }
  void reset_view() {
    view_x = -1.3333;
    view_w = 2.6666;
    view_y = -1.0;
    view_h = 2.0;
  }
  void use_juila_mode() {
    view_x_m = view_x;
    view_y_m = view_y;
    view_w_m = view_w;
    view_h_m = view_h;
    mode = JUILA_MODE;
    reset_view();
  }
  void use_mandelbrot_mode() {
    view_x = view_x_m;
    view_y = view_y_m;
    view_w = view_w_m;
    view_h = view_h_m;
    mode = MANDELBROT_MODE;
  }
  int calc_point(double x,double y,int max_iter){
    return 0;
  }
  void print_mode() {
    if (mode == MANDELBROT_MODE) {
      System.out.println("mandelbrot mode");
    }
    if (mode == JUILA_MODE) {
      System.out.println("juila mode");
    }
  }
  void read2(FractalInputStream i) throws IOException {
    
  }  
  void read(DataInputStream i) throws IOException {
  }
  void write(DataOutputStream o) throws IOException {
  }
  void prev_mode() {  
  }
  void next_mode() {    
  }
  void random() {
  }
  String get_status_text() {
    return "";
  }
  static abstract_fractalc get_new_fractal(int t) {
    abstract_fractalc f = null;
    if ((t >= 1400000002) & (t < 1400001000)) {
      f = new fractal_params_c(t-1400000000);
    }
    if (f != null) {
      f.fractal_type = t;
    }
    return f;
  }
}

class fractal_params_c extends abstract_fractalc {
  //int max_iter_pow2;
  int mode2;
  double param_real[];
  double param_img[];
  int num_params;
  fractal_params_c(int np) {
    max_iter_pow2 = 6;
    param_real = new double[np];
    param_img = new double[np];
    for (int i = 0;i < np;i++) {
      param_real[i] = 0;
      param_img[i] = 0;
    }
    mode2 = 0;
    num_params = np;
  }
  String get_status_text() {
    if (mode2 == 0) {
      return "p";
    } else if (mode2 == 1) {
      return "x*p";
    } else {
      return "(x^"+mode2+")*p";
    }
  }
  void random() {    
    for (int i = 2;i < num_params;i++) {
      double f1 = Math.random();
      double f2 = Math.random();
      param_real[i] = Math.cos(f1 * Math.PI * 2) * f2*2;
      param_img[i] = Math.sin(f1 * Math.PI * 2) * f2*2;
    }
  }
  void read2(FractalInputStream i) throws IOException {
    i.readInt();
    i.readInt();
    mode2 = i.readInt();
    for (int i2 = 0;i2 < num_params;i2++) {
      param_real[i2] = i.readDouble10();
      param_img[i2] = i.readDouble10();
    }
  }
  void read(DataInputStream i) throws IOException {
    i.readInt();
    i.readInt();
    i.readInt();
    i.readInt();

    i.readInt();
    i.readInt();
    i.readInt();
    i.readInt();
    i.readUnsignedShort();
    mode2 = i.readUnsignedShort();
    for (int i2 = 0;i2 < num_params;i2++) {
      param_real[i2] = i.readDouble();
      param_img[i2] = i.readDouble();
    }

  }
  void write(DataOutputStream o) throws IOException {
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);

    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeInt(0);
    o.writeShort(0);
    o.writeShort(mode2);
    for (int i = 0;i < num_params;i++) {
      o.writeDouble(param_real[i]);
      o.writeDouble(param_img[i]);
    }
  }

  void prev_mode() {  
    save_mode();
    mode2 = (mode2 + num_params - 1) % num_params;
    restore_mode();
  }
  void next_mode() {    
    save_mode();
    mode2 = (mode2 + 1) % num_params;
    restore_mode();  
  }
  void save_mode() {
    param_real[mode2] = view_x + (view_w * 0.5);
    param_img[mode2] = view_y + (view_h * 0.5);  
  }
  void restore_mode() {
    view_x = param_real[mode2] - (view_w * 0.5);
    view_y = param_img[mode2] - (view_h * 0.5);
  }
  int calc_point(double x,double y,int max_iter) {
    int i = 0;
    double x2 = 0;
    double y2 = 0;
    if (is_juila_mode_on() == true) {
      x2 = x;
      y2 = y;
    } else {
      param_real[mode2] = x;
      param_img[mode2] = y;
    }
    double x3 = 0;
    double y3 = 0;
    double x4 = 0;
    double y4 = 0;
    double xy = 0;
    double d = 0;
    double xy2 = 0;
    double b = Math.exp(Math.log(2)*num_params);
    while (i < max_iter) {
      d = (x2*x2)+(y2*y2);
      if (d >= b) {break;}
      x4 = x2;
      y4 = y2; 
      for (int i2 = num_params-1;i2 > 0;i2--) { 
        x3 = x4 + param_real[i2];
        y3 = y4 + param_img[i2];
        x4 = (x3*x2)-(y3*y2);
        y4 = (x3*y2)+(x2*y3);
      }
      x2 = x4 + param_real[0];
      y2 = y4 + param_img[0];
      i = i + 1;
    }  
    //total_iter = total_iter + i;
    return i;  
  }
}
class FractalInputStream extends FilterInputStream {
  public FractalInputStream(InputStream in) {
    super(in);
  }
  short readShort() throws IOException{
    short s = 0;
    int b = read();
    int b2 = read();
    s = (short) ((b2 << 8) + b);
    return s;
  }
  int readInt() throws IOException {
    int b = read();
    int b2 = read();
    int b3 = read();
    int b4 = read();
    return (b4 << 24) + (b3 << 16) + (b2 << 8) + b;
  }
  double readDouble10() throws IOException {
    double f2 = 0.0;
    for (int a = 0;a < 8;a++) {
      int b = read();
      double f = (double) b;
      f2 = (f2 + f) / 256.0;
    }
    short e = readShort();
    if (e < 0) {
      f2 = -f2;
      e = (short) (e ^ 0x8000);
    }
    f2 = f2 * Math.exp(Math.log(2)*(e-0x3FFE));
    readShort();
    //readShort();
    //readShort();
    //f2 = e;
    return f2;
  }
}
class fractalmainpanelc extends JPanel {
  static int thumbnail_width = 100;
  static int thumbnail_height = 75;
  static int thumbnail_size = 8420;
  Image img;
  int pix[];
  fractalmainpanelc() {
    int w = thumbnail_width;
    int h = thumbnail_height;
    pix = new int[(w * h)];    
  }  
  protected void paintComponent(Graphics g) {
    super.paintComponent(g);
    int w3 = thumbnail_width;
    int h3 = thumbnail_height;
    try {
      //BufferedInputStream i = new BufferedInputStream(new FileInputStream(fractalapp.filename));
      java.net.URL thumbnail_URL = fractalapp.class.getResource(fractalapp.filename);
      FractalInputStream in = new FractalInputStream(new BufferedInputStream(thumbnail_URL.openStream()));
      int y3 = 0;
      for (int y = 0;y < 10;y++) {
        int x3 = 0;
        for (int x = 0;x < 10;x++) {
          for (int y2 = 0;y2 < h3;y2++) {
            for (int x2 = 0;x2 < w3;x2++) {
              int b = in.read();
              pix[x2+(y2*w3)] = fractalapp.palette256[b];
            }
  	  }
          for (int i2 = 0;i2 < 3;i2++) {
            fractalapp.color_hue_freq[i2] = in.readShort();
            fractalapp.color_hue_phase[i2] = in.readShort();
	  }
	  fractalapp.update_palette256();
	  int s = thumbnail_size-(w3*h3)-12;
	  while (s > 0) {
	    s = s - (int)in.skip(s);
	  }
	  img = createImage(new MemoryImageSource(w3, h3, pix, 0, w3));
          g.drawImage(img,x3,y3,null);    
          x3 = x3 + w3 + 1;
        }
        y3 = y3 + h3 + 1;
      }
      in.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
}

class fractalmainwindowc extends JFrame implements WindowListener,KeyListener {
  fractalmainpanelc fractalmainpanel;
  char last_digit;
  fractalmainwindowc() {
    fractalmainpanel = new fractalmainpanelc();
    this.getContentPane().add(fractalmainpanel);  
    this.setVisible(true);
    this.addWindowListener(this);
    this.addKeyListener(this);
  }
  public void windowActivated(WindowEvent e) {
    System.out.println("Activated event");
    this.requestFocusInWindow();
    fractalmainpanel.repaint();
  }
  public void windowClosed(WindowEvent e) {
    System.out.println("Close event");
  }
  public void windowClosing(WindowEvent e) {
    System.out.println("Closing event");
    try {
      System.exit(0);
    } catch(SecurityException err) {
      System.out.println("can not exit");
    }
  }
  public void windowDeactivated(WindowEvent e) {
    System.out.println("Deactivated event");
  }
  public void windowDeiconified(WindowEvent e) {
    System.out.println("Deiconified event");
  }
  public void windowIconified(WindowEvent e) {
    System.out.println("Iconified event");
  }
  public void windowOpened(WindowEvent e) {
    System.out.println("Opened event");
  }
  //static short readShort(InputStream i) throws IOException{
    //fractalmainpanelc.readShort(i);
  //}  
  //static int readInt(InputStream i) throws IOException{
    //fractalmainpanelc.readInt(i);
  //}  
  //static int readDouble10(InputStream i) throws IOException{
    //fractalmainpanelc.readDouble10(i);
  //}  
  void load_fractal_from_menu(int i) {
    System.out.println("load_fractal_from_menu: " + i);
    try {  
      java.net.URL thumbnail_URL = fractalapp.class.getResource(fractalapp.filename);
      FractalInputStream in = new FractalInputStream(new BufferedInputStream(thumbnail_URL.openStream()));
      int w3 = fractalmainpanelc.thumbnail_width;
      int h3 = fractalmainpanelc.thumbnail_height;
      int s3 = fractalmainpanelc.thumbnail_size;
    
      int s = (s3*i)+(w3*h3);
      while (s > 0) {
        s = s - (int)in.skip(s);
      }
      for (int i2 = 0;i2 < 3;i2++) {
        fractalapp.color_hue_freq[i2] = in.readShort();
        fractalapp.color_hue_phase[i2] = in.readShort();
      }
      int t = in.readInt();
      abstract_fractalc f = abstract_fractalc.get_new_fractal(t);
      System.out.println("t: " + t);
      in.readInt();
      in.readInt();
      in.readInt();
      in.readInt();
      f.mode = in.readInt();
      in.readShort();
      f.max_iter_pow2 = in.readShort();
      int id17 = in.readInt();
      f.view_x_m = in.readDouble10();
      f.view_w_m = in.readDouble10();
      f.view_y_m = in.readDouble10();
      f.view_h_m = in.readDouble10();
      f.view_x = in.readDouble10();
      f.view_w = in.readDouble10();
      f.view_y = in.readDouble10();
      f.view_h = in.readDouble10();
      //System.out.println(id17);
      f.read2(in);
      System.out.println(f.view_x_m + ", " + f.view_y_m + ", " + f.view_w_m + ", " + f.view_h_m);     System.out.println(f.view_x + ", " + f.view_y + ", " + f.view_w + ", " + f.view_h);
      in.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }
  public void keyTyped(KeyEvent e) {
    char ch = e.getKeyChar();
    if ((ch >= '0') & (ch <= '9')) {
      char ch2 = last_digit;
      if ((ch2 >= '0') & (ch2 <= '9')) {
        int i = ((ch2-'0')*10)+(ch-'0');
	load_fractal_from_menu(i);
        last_digit = 0;
      } else {
        last_digit = ch;
      }
    }
  }
  public void keyPressed(KeyEvent e) {
    int a = e.getKeyCode();
    boolean ctrl = e.isControlDown();
  }
  public void keyReleased(KeyEvent e) {
  }
}
class fractalapp implements Runnable {
  static String filename = "thumbnails2347894734598234970239857";
  static int palette256[];
  static short color_hue_freq[] = {1,1,1}; 
  static short color_hue_phase[] = {0,10,20};
  static fractalmainwindowc fractalmainwindow;
  static int get_color_hue_value2(int i,int i2) {
    int f = color_hue_freq[i2];
    int p = color_hue_phase[i2];

    return (int) ((1.0-Math.cos((((((double) i) * f) + (p*4)) * Math.PI*2) / 256.0))*127.0);
  }
  static void update_palette256() {
    palette256[0] = 0xFF000000;
    for (int i = 1;i < 256;i++) {
      palette256[i] = get_color32(i);
    }
  }
  static int get_color32(int i) {
    if (i == 0) {return 0;}
    int r = get_color_hue_value2(i,0);
    int g = get_color_hue_value2(i,1);
    int b = get_color_hue_value2(i,2);
    return (255 << 24) + (b << 16) + (g << 8) + r;
  }
  
  public static void main(String[] args ){
    palette256 = new int[256];
    update_palette256();
    //try {
    //FractalInputStream in = new FractalInputStream(System.in);
    //System.out.println(in.readDouble10());
    //} catch (IOException e) {
    //  e.printStackTrace();
    //}
    
    javax.swing.SwingUtilities.invokeLater(new fractalapp());
    
  }
  public void run() {          
    fractalmainwindow = new fractalmainwindowc();
  }
}

